/****** Object:  StoredProcedure [dbo].[P_EST_PROD_PRECO_ROLLBACK_EXECUTE_ALL]    Script Date: 11/07/2013 18:13:23 ******/
IF EXISTS( SELECT * FROM sys.objects
				WHERE  object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_ROLLBACK_EXECUTE_ALL]')
					   AND type IN(N'P', N'PC')
)
	BEGIN
		DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_ROLLBACK_EXECUTE_ALL];
	END;
GO
GO
GO
--EXEC P_EST_PROD_PRECO_ROLLBACK_EXECUTE_ALL 0,'2018-05-09'

CREATE PROCEDURE [dbo].[P_EST_PROD_PRECO_ROLLBACK_EXECUTE_ALL] @CD_FILIAL_PAR INT      = 0
															 , @DT_REF AS        DATETIME
AS
	 BEGIN
		 PRINT 'Inicio do rollback';
		 SET NOCOUNT ON;
		 DECLARE @CD_FILIAL INT;
		 DECLARE @CD_EMP INT;



		 DECLARE ProcPrecoRollback CURSOR FAST_FORWARD
		 FOR SELECT
					CD_EMP
				  , CD_FILIAL
			 FROM
				 PRC_FILIAL
			 WHERE  CD_FILIAL = CASE
									WHEN @CD_FILIAL_PAR > 0 THEN @CD_FILIAL_PAR
									ELSE CD_FILIAL
								END;



		 OPEN ProcPrecoRollback;
		 FETCH NEXT FROM ProcPrecoRollback INTO @CD_EMP
											  , @CD_FILIAL;
		 WHILE @@FETCH_STATUS = 0
			 BEGIN
				 PRINT 'Filial '+CONVERT(VARCHAR(10), @CD_FILIAL)+' '+CONVERT(VARCHAR, GETDATE(), 108);


				 EXEC P_EST_PROD_PRECO_ROLLBACK
					  @CD_EMP
					, @CD_FILIAL
					, @DT_REF;
				 FETCH NEXT FROM ProcPrecoRollback INTO @CD_EMP
													  , @CD_FILIAL;
			 END;
		 PRINT 'Concluido.';
		 CLOSE ProcPrecoRollback;
		 DEALLOCATE ProcPrecoRollback;
	 END;